//
//  HighPriorityButtonStyle.swift
//  Do It
//
//  Created by Jim Dovey on 5/20/20.
//  Copyright © 2020 Pragmatic Programmers. All rights reserved.
//

import SwiftUI

// START:ButtonStyleDecl
struct HighPriorityButtonStyle: PrimitiveButtonStyle {
    // END:ButtonStyleDecl
    // START:MakeBody
    func makeBody(configuration: Configuration) -> some View {
        Inner(configuration: configuration)
    }
    // END:MakeBody
    
    // START:InnerButtonView
    private struct Inner: View {
        @State var pressed = false
        let configuration: PrimitiveButtonStyle.Configuration
        
        var body: some View {
            // <literal:elide> ... </literal:elide>
            // START:InnerButtonBody
            // END:InnerButtonView
            // START:GestureMap
            let gesture = DragGesture(minimumDistance: 0)
                .map { translation($0.translation, doesNotExceed: 15) }
            // END:GestureMap
            // START:GestureChanged
                .onChanged { self.pressed = $0 }
            // END:GestureChanged
            // START:GestureEnded
                .onEnded { _ in
                    guard self.pressed else { return }
                    self.pressed = false
                    self.configuration.trigger()
                }
            // END:GestureEnded
            
            // START_HIGHLIGHT
            return configuration.label
                .opacity(pressed ? 0.5 : 1.0)
                .highPriorityGesture(gesture)
            // END_HIGHLIGHT
            // START:InnerButtonView
            // END:InnerButtonBody
        }
    }
    // END:InnerButtonView
    // START:ButtonStyleDecl
}
// END:ButtonStyleDecl

struct HighPriorityButtonStyle_Previews: PreviewProvider {
    // START:Preview
    static var previews: some View {
        NavigationView {
            List {
                NavigationLink(destination: Text("Hello")) {
                    Button(action: { print("hello") }) {
                        Text("Button!")
                            .foregroundColor(.accentColor)
                    }
                    .buttonStyle(HighPriorityButtonStyle())
                }
            }
        }
    }
    // END:Preview
}
